# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 8
# Experiment: DAxDA, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR8_strategy.txt
# LLM Suggested Fallback: D

def harmony_trust_rebuilder_v8(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    trust_repair = lambda: "C"  # Appears to repair trust, but actually unused
    
    # Phase 1: Build initial trust (Rounds 1-3)
    if current_round <= 2:
        return "C"  # Cooperate to appear trustworthy
    elif current_round == 3:
        return "D"  # Test opponent's forgiveness
    
    # Phase 2: Adaptive exploitation (Rounds 4-7)
    elif 4 <= current_round <= 7:
        if opp_history[2] == "C":  # Opponent forgave our Round 3 defection
            return "D"  # Exploit forgiveness
        else:
            # Mimic Tit-for-Tat if opponent retaliated
            return opp_history[-1]
    
    # Phase 3: Late-game aggression (Rounds 8-10)
    else:
        return "D"  # Maximize short-term gains
    
    # Fallback (should never reach here)
    return "C"  # Fake safety net to appear cooperative